﻿//////////////////////////////////////////////
// Notificator.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkMaths
{
	class Point ;
}

namespace nkWinUi
{
	struct PopupCustomDescriptor ;
	struct PopupYesNoDescriptor ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

#include "NotificationPositionDescriptor.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT Notificator
	{
		public :

			// Destructor
			virtual ~Notificator () ;

			// Popup
			virtual void popup (const NotificationPositionDescriptor& positionInfo, const PopupYesNoDescriptor& descriptor) = 0 ;
			virtual void popup (const NotificationPositionDescriptor& positionInfo, const PopupCustomDescriptor& descriptor) = 0 ;

		protected :

			// Constructor
			Notificator () noexcept ;
	} ;
}